/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.util;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.configuration.ConfigCache;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.util.People;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;

public class BackpackUtils {
    public static boolean curiosLoaded = false;
    private static final HashMap<String, Confirmation> confirmationMap = new HashMap();

    public static boolean filterItem(ItemStack stack) {
        if (ConfigCache.WHITELIST.contains(stack.m_41720_().getRegistryName())) {
            return true;
        }
        if (stack.m_204117_(SimplyBackpacks.HOLDS_ITEMS)) {
            return false;
        }
        if (!stack.m_41720_().m_142095_()) {
            return false;
        }
        return !ConfigCache.BLACKLIST.contains(stack.m_41720_().getRegistryName());
    }

    public static ItemStack findBackpackForHotkeys(Player player, boolean includeHands) {
        ItemStack stack;
        if (includeHands && player.m_21205_().m_41720_() instanceof BackpackItem) {
            return player.m_21205_();
        }
        if (includeHands && player.m_21206_().m_41720_() instanceof BackpackItem) {
            return player.m_21206_();
        }
        if (curiosLoaded && !(stack = CuriosApi.getCuriosHelper().findEquippedCurio(BackpackItem::isBackpack, (LivingEntity)player).map(data -> {
            if (((ItemStack)data.getRight()).m_41720_() instanceof BackpackItem) {
                return (ItemStack)data.getRight();
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_)).m_41619_()) {
            return stack;
        }
        Inventory inventory = player.m_150109_();
        for (int i = 0; i <= 35; ++i) {
            ItemStack stack2 = inventory.m_8020_(i);
            if (!(stack2.m_41720_() instanceof BackpackItem)) continue;
            return stack2;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public static Optional<UUID> getUUID(@Nonnull ItemStack stack) {
        if (stack.m_41720_() instanceof BackpackItem && stack.m_41782_() && stack.m_41783_().m_128441_("UUID")) {
            return Optional.of(stack.m_41783_().m_128342_("UUID"));
        }
        return Optional.empty();
    }

    public static Set<String> getUUIDSuggestions(CommandContext<CommandSourceStack> commandSource) {
        BackpackManager backpacks = BackpackManager.get();
        HashSet<String> list = new HashSet<String>();
        backpacks.getMap().forEach((uuid, backpackData) -> list.add(uuid.toString()));
        return list;
    }

    public static boolean increasedAltChance(UUID uuidIn) {
        if (uuidIn.compareTo(People.FLANKS255) == 0) {
            return true;
        }
        if (uuidIn.compareTo(People.ELLPECK) == 0) {
            return true;
        }
        return uuidIn.compareTo(People.LONEZTAR) == 0;
    }

    public static void ifTag(ItemStack stack, Consumer<CompoundTag> consumer) {
        if (stack.m_41782_()) {
            consumer.accept(stack.m_41783_());
        }
    }

    public static void ifTagContains(ItemStack stack, String child, Consumer<CompoundTag> consumer) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(child)) {
            consumer.accept(stack.m_41783_());
        }
    }

    public static Optional<CompoundTag> getTag(ItemStack stack) {
        if (stack.m_41782_()) {
            return Optional.of(stack.m_41783_());
        }
        return Optional.empty();
    }

    public static String generateCode(Random random) {
        return "%08x".formatted(random.nextInt(Integer.MAX_VALUE));
    }

    public static void addConfirmation(String code, UUID player, UUID backpack) {
        confirmationMap.put(code, new Confirmation(code, player, backpack));
    }

    public static void removeConfirmation(String code) {
        confirmationMap.remove(code);
    }

    public static Optional<Confirmation> getConfirmation(String code) {
        return Optional.ofNullable(confirmationMap.get(code));
    }

    public record Confirmation(String code, UUID player, UUID backpack) {
    }
}

